<?php

// =========================
//   IMPORTS CONTROLLERS
// =========================
require_once __DIR__ . '/../auth/AuthController.php';
require_once __DIR__ . '/../controllers/DashboardController.php';
require_once __DIR__ . '/../cotisations/CotisationController.php';
require_once __DIR__ . '/../membres/MembreController.php';
require_once __DIR__ . '/../arrieres/ArriereController.php';
require_once __DIR__ . '/../dons/DonController.php';
require_once __DIR__ . '/../autres/AutreCotisationController.php';

// =========================
//   ROUTE PARSING
// =========================
$uri = explode("/", trim(parse_url($_SERVER["REQUEST_URI"], PHP_URL_PATH), "/"));

// =========================
//   CORS
// =========================
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

if ($_SERVER["REQUEST_METHOD"] === "OPTIONS") {
    http_response_code(204);
    exit;
}

// Helper routes
$root = $uri[0] ?? null;
$endpoint = $uri[1] ?? null;
$param = $uri[2] ?? null;

// =======================================================
// 🔐 AUTH : /api/auth/login
// =======================================================
if ($root === "api" && $endpoint === "auth") {

    $controller = new AuthController();

    if ($param === "login" && $_SERVER["REQUEST_METHOD"] === "POST") {
        $controller->login();
        exit;
    }
}

// =======================================================
// 📊 DASHBOARD : /api/dashboard/{id}
// =======================================================
if ($root === "api" && $endpoint === "dashboard" && $_SERVER["REQUEST_METHOD"] === "GET") {

    if (is_numeric($param)) {
        $controller = new DashboardController();
        $controller->getDashboard(intval($param));
        exit;
    }
}

// =======================================================
// 💰 COTISATIONS
// /api/cotisations/membre/{id}
// /api/cotisations/historique/{id}
// /api/cotisations/payer
// =======================================================
if ($root === "api" && $endpoint === "cotisations") {

    $controller = new CotisationController();

    // GET cotisations d'un membre
    if ($param === "membre" && isset($uri[3]) && $_SERVER["REQUEST_METHOD"] === "GET") {
        $controller->getCotisationsMembre(intval($uri[3]));
        exit;
    }

    // GET historique complet
    if ($param === "historique" && isset($uri[3]) && $_SERVER["REQUEST_METHOD"] === "GET") {
        $controller->getHistoriqueMembre(intval($uri[3]));
        exit;
    }

    // POST paiement
    if ($param === "payer" && $_SERVER["REQUEST_METHOD"] === "POST") {
        $controller->payerCotisation();
        exit;
    }
}

// =======================================================
// 👥 MEMBRES
// /api/membres
// /api/membres/{id}
// /api/membres/create
// /api/membres/update
// /api/membres/delete
// =======================================================
if ($root === "api" && $endpoint === "membres") {

    $controller = new MembreController();

    // GET all membres
    if ($_SERVER["REQUEST_METHOD"] === "GET" && !$param) {
        $controller->getAll();
        exit;
    }

    // GET single membre
    if (is_numeric($param) && $_SERVER["REQUEST_METHOD"] === "GET") {
        $controller->getMembre(intval($param));
        exit;
    }

    // Create
    if ($param === "create" && $_SERVER["REQUEST_METHOD"] === "POST") {
        $controller->create();
        exit;
    }

    // Update
    if ($param === "update" && $_SERVER["REQUEST_METHOD"] === "POST") {
        $controller->update();
        exit;
    }

    // Update PIN
    if ($param === "update-pin" && $_SERVER["REQUEST_METHOD"] === "POST") {
        $controller->updatePin();
        exit;
    }

    // Delete
    if ($param === "delete" && $_SERVER["REQUEST_METHOD"] === "POST") {
        $controller->delete();
        exit;
    }
}

// =======================================================
// 🟠 ARRIERES (VERSION CORRECTE)
// =======================================================
// /api/arrieres/membre/{id}
// /api/arrieres/regler

if ($root === "api" && $endpoint === "arrieres") {

    $controller = new ArriereController();

    // GET arriérés d’un membre
    if ($param === "membre" && isset($uri[3]) && $_SERVER["REQUEST_METHOD"] === "GET") {
        $controller->getArrieresMembre(intval($uri[3]));
        exit;
    }

    // POST régler un arriéré
    if ($param === "regler" && $_SERVER["REQUEST_METHOD"] === "POST") {
        $controller->regler();
        exit;
    }
}

// =======================================================
// 🟣 DONS
// /api/dons
// =======================================================
if ($root === "api" && $endpoint === "dons") {

    $controller = new DonController();

    if ($_SERVER["REQUEST_METHOD"] === "GET") {
        $controller->getAll();
        exit;
    }

    if ($_SERVER["REQUEST_METHOD"] === "POST") {
        $controller->add();
        exit;
    }
}

// =======================================================
// 🟤 AUTRES COTISATIONS
// /api/autres
// =======================================================
if ($root === "api" && $endpoint === "autres") {

    $controller = new AutreCotisationController();

    if ($_SERVER["REQUEST_METHOD"] === "GET") {
        $controller->getAll();
        exit;
    }

    if ($_SERVER["REQUEST_METHOD"] === "POST") {
        $controller->add();
        exit;
    }
}

// =======================================================
// ❌ ROUTE INCONNUE
// =======================================================
http_response_code(404);
echo json_encode(["success" => false, "message" => "Route inconnue"]);

