<?php
class CotisationMensuelleModel {
    private $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    /**
     * Ajoute une cotisation mensuelle avec opération liée
     */
    public function ajouter($membreId, $montant, $annee, $mois) {
        // Vérifier doublon
        $check = $this->pdo->prepare("
            SELECT COUNT(*) FROM cotisations_membres
            WHERE membre_id = ? AND annee = ? AND mois = ?
        ");
        $check->execute([$membreId, $annee, $mois]);
        if ($check->fetchColumn() > 0) {
            return "doublon";
        }

        try {
            $this->pdo->beginTransaction();

            // Créer l'opération
            $stmtOp = $this->pdo->prepare("
                INSERT INTO operations (type, montant, description, categorie_id, date_operation, created_by, commentaire)
                VALUES ('recette', ?, 'Cotisation mensuelle', 1, CURDATE(), ?, '')
            ");
            $stmtOp->execute([$montant, $membreId]);
            $operationId = $this->pdo->lastInsertId();

            // Enregistrer la cotisation
            $stmtCot = $this->pdo->prepare("
                INSERT INTO cotisations_membres (membre_id, operation_id, annee, mois, montant)
                VALUES (?, ?, ?, ?, ?)
            ");
            $stmtCot->execute([$membreId, $operationId, $annee, $mois, $montant]);

            $this->pdo->commit();
            return true;

        } catch (Exception $e) {
            $this->pdo->rollBack();
            return false;
        }
    }

    /**
     * Liste brute des cotisations
     */
    public function tout() {
        $stmt = $this->pdo->query("SELECT * FROM cotisations_membres ORDER BY annee DESC, mois DESC");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    /**
     * Calcul des arriérés par membre
     */
    public function calculArrieres() {
        $stmt = $this->pdo->query("
            SELECT m.id AS membre_id, m.nom, m.prenom,
                   COUNT(*) AS mois_en_retard,
                   MIN(h.mois) AS premier_mois,
                   SUM(h.montant_du - h.montant_paye) AS total_du
            FROM historiques_arriere h
            JOIN membres m ON m.id = h.membre_id
            WHERE h.statut = 'en_retard'
            GROUP BY h.membre_id
        ");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    /**
     * Export enrichi des cotisations avec opérations et membres
     */
    public function exportCotisations() {
        $stmt = $this->pdo->query("
            SELECT 
                m.nom, 
                m.prenom, 
                CONCAT(m.nom, ' ', m.prenom) AS nom_complet,
                c.annee, 
                c.mois, 
                c.montant,
                o.date_operation, 
                o.description
            FROM cotisations_membres c
            JOIN membres m ON m.id = c.membre_id
            JOIN operations o ON o.id = c.operation_id
            ORDER BY c.annee DESC, c.mois DESC
        ");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
